def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Debut of the core actions
        gripper_position = 'gripper_slot_position'  # Example gripper position placeholder
        drawer = 'drawer'  # Replace with actual drawer object if known
        target_obj = 'target_object'  # Replace with actual target object if known

        # Execute the task plan
        print(f"[Task] Moving to gripper position: {gripper_position}")
        obs, reward, done = move(env, 'current_location', gripper_position)
        
        if done:
            print("[Task] Task ended while moving!")
            return

        print(f"[Task] Picking up {target_obj}...")
        obs, reward, done = pick(env, target_obj, 'current_location', 'gripper')

        if done:
            print("[Task] Task ended after picking object!")
            return

        print(f"[Task] Placing {target_obj}...")
        obs, reward, done = place(env, target_obj, 'desired_location')

        if done:
            print("[Task] Task ended after placing object!")
            return
        
        print(f"[Task] Attempting to open drawer {drawer}...")
        obs, reward, done = pick_drawer(env, 'gripper', drawer, gripper_position)

        if done:
            print("[Task] Task ended after attempting to pick drawer!")
            return

        print(f"[Task] Pulling the drawer {drawer}...")
        obs, reward, done = pull(env, 'gripper', drawer)

        if done:
            print("[Task] Task ended while pulling the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()