def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # This is an example of how objects may be referenced in the environment
        drawer_pos = positions['bottom_anchor_pos']
        side_pos = positions['side-pos-bottom']
        
        # 1) Move to the drawer location
        print("[Task] Moving to the drawer position at:", drawer_pos)
        obs = move(env, 'nowhere', drawer_pos)  # To be customized based on the actual initial position of the robot
        
        # 2) Pick the drawer handle
        print("[Task] Picking the drawer handle.")
        obs = pick(env, 'drawer_handle', drawer_pos, 'gripper1')
        
        # 3) Open the drawer
        print("[Task] Opening the drawer.")
        obs = pull(env, 'drawer_handle', drawer_pos)

        # 4) Pick the tomatoes from the drawer
        print("[Task] Picking tomatoes from the drawer.")
        obs = pick(env, 'tomatoes', drawer_pos, 'gripper1')
        
        # 5) Move to the plate location (assumed predefined)
        plate_pos = positions['plate_pos']
        print("[Task] Moving to the plate position at:", plate_pos)
        obs = move(env, drawer_pos, plate_pos)

        # 6) Place the tomatoes on the plate
        print("[Task] Placing tomatoes on the plate.")
        obs = place(env, 'tomatoes', plate_pos)
        
    finally:
        # Always ensure the environment is properly shut down
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()