def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example object positions
        robot_position = positions['robot']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        rubbish_pos = positions['rubbish']
        plate_pos = positions['plate']
        drawer_bottom_pos = positions['drawer_bottom']
        
        # Step 1: Move to the drawer to pick up a tomato
        print("[Task] Moving to drawer bottom position:", drawer_bottom_pos)
        obs, reward, done = move(env, task, target_pos=drawer_bottom_pos)

        if done:
            print("[Task] Task ended after moving to drawer!")
            return

        # Step 2: Open the drawer to access tomatoes
        print("[Task] Opening the drawer to access tomatoes.")
        obs, reward, done = pick(env, 'drawer_handle', drawer_bottom_pos, 'gripper')

        if done:
            print("[Task] Task ended after attempting to pick drawer handle!")
            return
        
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, 'gripper', 'drawer_bottom', drawer_bottom_pos)
        
        if done:
            print("[Task] Task ended after pulling open the drawer!")
            return

        # Step 3: Move to pick up the first tomato
        print("[Task] Moving to pick up tomato1 at position:", tomato1_pos)
        obs, reward, done = move(env, task, target_pos=tomato1_pos)

        if done:
            print("[Task] Task ended after moving to tomato1!")
            return
        
        print("[Task] Picking up tomato1.")
        obs, reward, done = pick(env, 'tomato1', 'drawer_bottom')

        if done:
            print("[Task] Task ended after picking up tomato1!")
            return

        # Step 4: Move to place the first tomato on the plate
        print("[Task] Moving to place tomato1 on the plate at position:", plate_pos)
        obs, reward, done = move(env, task, target_pos=plate_pos)

        if done:
            print("[Task] Task ended after moving to plate!")
            return
        
        print("[Task] Placing tomato1 on the plate.")
        obs, reward, done = place(env, 'tomato1', plate_pos)

        if done:
            print("[Task] Task ended after placing tomato1!")
            return

        # Step 5: Move to pick up the second tomato
        print("[Task] Moving to pick up tomato2 at position:", tomato2_pos)
        obs, reward, done = move(env, task, target_pos=tomato2_pos)

        if done:
            print("[Task] Task ended after moving to tomato2!")
            return
        
        print("[Task] Picking up tomato2.")
        obs, reward, done = pick(env, 'tomato2', 'drawer_bottom')

        if done:
            print("[Task] Task ended after picking up tomato2!")
            return

        # Step 6: Move to place the second tomato on the plate
        print("[Task] Moving to place tomato2 on the plate at position:", plate_pos)
        obs, reward, done = move(env, task, target_pos=plate_pos)

        if done:
            print("[Task] Task ended after moving to plate!")
            return
        
        print("[Task] Placing tomato2 on the plate.")
        obs, reward, done = place(env, 'tomato2', plate_pos)

        if done:
            print("[Task] Task ended after placing tomato2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()