def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a drawer and objects we need to interact with
        drawer_position = positions['drawer']
        tomato1_position = positions['tomato1']
        tomato2_position = positions['tomato2']
        plate_position = positions['plate']

        # Step 1: Move to the drawer to pick it
        print("[Task] Moving to drawer position:", drawer_position)
        obs, reward, done = move(env, task, drawer_position)
        if done:
            print("[Task] Task ended after moving to drawer!")
            return

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer")
        obs, reward, done = pick(env, "drawer_object", drawer_position, "gripper")
        if done:
            print("[Task] Task ended after picking drawer!")
            return
        
        # Step 3: Open the drawer
        print("[Task] Opening the drawer")
        obs, reward, done = pull(env, "gripper", "drawer_object", drawer_position)
        if done:
            print("[Task] Task ended after opening drawer!")
            return
        
        # Step 4: Pick tomato 1
        print("[Task] Picking tomato 1")
        obs, reward, done = pick(env, "tomato1", tomato1_position, "gripper")
        if done:
            print("[Task] Task ended after picking tomato 1!")
            return
        
        # Step 5: Place tomato 1 on the plate
        print("[Task] Placing tomato 1 on the plate")
        obs, reward, done = place(env, "tomato1", plate_position)
        if done:
            print("[Task] Task ended after placing tomato 1!")
            return

        # Step 6: Pick tomato 2
        print("[Task] Picking tomato 2")
        obs, reward, done = pick(env, "tomato2", tomato2_position, "gripper")
        if done:
            print("[Task] Task ended after picking tomato 2!")
            return
            
        # Step 7: Place tomato 2 on the plate
        print("[Task] Placing tomato 2 on the plate")
        obs, reward, done = place(env, "tomato2", plate_position)
        if done:
            print("[Task] Task ended after placing tomato 2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()