def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming certain object names based on typical scenarios
        gripper = 'gripper'
        drawer = 'drawer1'  # Example drawer name
        object_to_pick = 'object_to_pick'  # This should be replaced with actual object name from your environment

        # 1) Rotate the gripper to its initial angle
        initial_angle = 'initial_angle'  # Specify the appropriate angle
        obs = rotate(env, task, initial_angle)

        # 2) Move to the location of the object to be picked
        object_location = positions[object_to_pick]
        print(f"[Task] Moving to location of {object_to_pick} at:", object_location)
        obs, reward, done = move(env, gripper, obs.gripper_pose[:3], object_location)

        if done:
            print("[Task] Task ended after moving to object location!")
            return

        # 3) Pick the object
        print(f"[Task] Picking up the {object_to_pick}...")
        obs, reward, done = pick(env, object_to_pick, object_location, gripper)

        if done:
            print("[Task] Task ended after picking the object!")
            return

        # 4) Move to the drawer location, which may have a separate defined position.
        drawer_location = positions[drawer]
        print(f"[Task] Moving to the {drawer} at:", drawer_location)
        obs, reward, done = move(env, gripper, obs.gripper_pose[:3], drawer_location)

        if done:
            print("[Task] Task ended after moving to drawer location!")
            return

        # 5) Open the drawer
        print(f"[Task] Opening the {drawer}...")
        obs, reward, done = pull(env, gripper, drawer)

        if done:
            print("[Task] Task ended after opening the drawer!")
            return
        
        # 6) Place the object in the drawer
        print(f"[Task] Placing the object inside the {drawer}...")
        obs, reward, done = place(env, object_to_pick, drawer_location)

        if done:
            print("[Task] Task ended after placing the object!")
            return

        # Final observation to ensure completion
        print("[Task] All actions completed successfully!")

    finally:
        # Always ensure the environment is properly shut down
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()