def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Access specific object positions
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        plate_pos = positions['plate']
        drawer_pos = positions['drawer']
        
        # 1) Move to the drawer and check its status
        print("[Task] Moving to the drawer")
        obs, reward, done = move(env, "robot_pos", drawer_pos)
        if done:
            print("[Task] Task ended while moving to the drawer!")
            return

        # 2) Open the drawer
        print("[Task] Opening the drawer")
        obs, reward, done = pick(env, "drawer_handle", drawer_pos, "gripper")
        if done:
            print("[Task] Task ended after picking drawer handle!")
            return
            
        print("[Task] Pulling the drawer open")
        obs, reward, done = pull(env, "drawer_handle", drawer_pos)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return
        
        # 3) Move tomatoes to the plate
        print("[Task] Picking tomato 1")
        obs, reward, done = pick(env, "tomato1", tomato1_pos, "gripper")
        if done:
            print("[Task] Task ended after picking tomato 1!")
            return

        print("[Task] Placing tomato 1 on the plate")
        obs, reward, done = place(env, "tomato1", plate_pos)
        if done:
            print("[Task] Task ended after placing tomato 1!")
            return

        print("[Task] Picking tomato 2")
        obs, reward, done = pick(env, "tomato2", tomato2_pos, "gripper")
        if done:
            print("[Task] Task ended after picking tomato 2!")
            return

        print("[Task] Placing tomato 2 on the plate")
        obs, reward, done = place(env, "tomato2", plate_pos)
        if done:
            print("[Task] Task ended after placing tomato 2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()