def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve Object Positions
        positions = get_object_positions()
        
        # Assuming the drawers' anchors and side positions are defined correctly.
        bottom_anch_pos = positions['bottom_anchor_pos']
        bottom_side_pos = positions['bottom_side_pos']
        plate_pos = positions['plate_pos']
        tomato1_pos = positions['tomato1_pos']
        tomato2_pos = positions['tomato2_pos']

        # Move to the bottom drawer's side position
        print("[Task] Moving to bottom drawer's side position.")
        obs, reward, done = move(env, obs.robot_position, bottom_side_pos)
        if done:
            print("[Task] Task ended while moving to the drawer's side position!")
            return
        
        # Pick the bottom drawer
        print("[Task] Picking up the bottom drawer.")
        obs, reward, done = pick(env, "bottom_drawer", bottom_side_pos)
        if done:
            print("[Task] Task ended while picking the drawer!")
            return
        
        # If the drawer is not locked and is held
        print("[Task] Opening the bottom drawer.")
        obs, reward, done = pull(env, "bottom_drawer", bottom_side_pos)
        if done:
            print("[Task] Task ended while opening the drawer!")
            return

        # Pick the tomatoes
        print("[Task] Moving to pick tomato 1.")
        obs, reward, done = move(env, bottom_side_pos, tomato1_pos)
        if done:
            print("[Task] Task ended while moving to tomato 1!")
            return
        
        print("[Task] Picking tomato 1.")
        obs, reward, done = pick(env, "tomato1", tomato1_pos)
        if done:
            print("[Task] Task ended while picking tomato 1!")
            return

        print("[Task] Moving to plate to place tomato 1.")
        obs, reward, done = move(env, tomato1_pos, plate_pos)
        if done:
            print("[Task] Task ended while moving to plate for tomato 1!")
            return
        
        print("[Task] Placing tomato 1 on plate.")
        obs, reward, done = place(env, "tomato1", plate_pos)
        if done:
            print("[Task] Task ended while placing tomato 1!")
            return

        print("[Task] Moving to pick tomato 2.")
        obs, reward, done = move(env, plate_pos, tomato2_pos)
        if done:
            print("[Task] Task ended while moving to tomato 2!")
            return

        print("[Task] Picking tomato 2.")
        obs, reward, done = pick(env, "tomato2", tomato2_pos)
        if done:
            print("[Task] Task ended while picking tomato 2!")
            return

        print("[Task] Moving to plate to place tomato 2.")
        obs, reward, done = move(env, tomato2_pos, plate_pos)
        if done:
            print("[Task] Task ended while moving to plate for tomato 2!")
            return
        
        print("[Task] Placing tomato 2 on plate.")
        obs, reward, done = place(env, "tomato2", plate_pos)
        if done:
            print("[Task] Task ended while placing tomato 2!")
            return

    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()