def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define the objects and locations based on the observation
        robot_position = 'initial_room'
        object_to_pick = 'object_1'
        object_to_place = 'object_2'

        # Example Task Plan
        # 1) Move to the location of the object to pick
        print("[Task] Moving to the location of the object.")
        obs, reward, done = move(env, robot_position, positions[object_to_pick])
        if done:
            print("[Task] Task ended after moving to object location!")
            return

        # 2) Pick up the object
        print(f"[Task] Picking up {object_to_pick}.")
        obs, reward, done = pick(env, object_to_pick, positions[object_to_pick], 'gripper')
        if done:
            print("[Task] Task ended after picking up the object!")
            return

        # 3) Move to the location to place the object
        print("[Task] Moving to the location to place the object.")
        obs, reward, done = move(env, positions[object_to_pick], positions[object_to_place])
        if done:
            print("[Task] Task ended after moving to place location!")
            return

        # 4) Place the object
        print(f"[Task] Placing down {object_to_pick}.")
        obs, reward, done = place(env, object_to_place, positions[object_to_place])
        if done:
            print("[Task] Task ended after placing the object!")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()