def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the retrieved data
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        table_pos = positions['table']
        gripper_pos = positions['gripper']

        # Step 1: Move to the location of the first object (tomato1)
        print("[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, gripper_pos, tomato1_pos)
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return

        # Step 2: Pick the first object (tomato1)
        print("[Task] Picking up tomato1.")
        obs, reward, done = pick(env, 'tomato1', 'table', 'gripper')
        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        # Step 3: Move to the location of the second object (tomato2)
        print("[Task] Moving to tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, tomato1_pos, tomato2_pos)
        if done:
            print("[Task] Task ended after moving to tomato2!")
            return

        # Step 4: Place the first object (tomato1) at the location of the second object (tomato2)
        print("[Task] Placing tomato1 at tomato2's position.")
        obs, reward, done = place(env, task, tomato2_pos)
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

        # Step 5: Move back to the table
        print("[Task] Moving back to the table.")
        obs, reward, done = move(env, tomato2_pos, table_pos)
        if done:
            print("[Task] Task ended after moving back to the table!")
            return

        # Step 6: Pick the second object (tomato2)
        print("[Task] Picking up tomato2.")
        obs, reward, done = pick(env, 'tomato2', 'table', 'gripper')
        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        # Step 7: Place the second object (tomato2) at a designated position (e.g., a disposal area)
        print("[Task] Placing tomato2 at the disposal area.")
        disposal_area_pos = positions['disposal_area']  # Assuming this position is defined
        obs, reward, done = place(env, task, disposal_area_pos)
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")