[Frozen Code Start]

[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import pick, place, move, rotate, pull, close_gripper, press

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Skeleton for running the tomato‐on‐plate task.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing simulation (optional)
        init_video_writers(obs)

        # Wrap task.step and task.get_observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve object positions
        positions = get_object_positions()
        
        # Oracle plan: pick and place two tomatoes
        tomatoes = ['tomato1', 'tomato2']
        for tomato in tomatoes:
            # Pick step
            if tomato not in positions:
                raise KeyError(f"Position for {tomato} not found in environment")
            pick_pos = np.array(positions[tomato])
            print(f"[Task] Picking up {tomato} at {pick_pos}")
            obs, reward, done = pick(
                env,
                task,
                target_pos=pick_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print(f"[Task] Task ended during pick of {tomato}! Reward: {reward}")
                return

            # Place step
            if 'plate' not in positions:
                raise KeyError("Position for plate not found in environment")
            place_pos = np.array(positions['plate'])
            print(f"[Task] Placing {tomato} on plate at {place_pos}")
            obs, reward, done = place(
                env,
                task,
                target_pos=place_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print(f"[Task] Task ended during place of {tomato}! Reward: {reward}")
                return

        # All steps completed
        print("[Task] All tomatoes placed on the plate. Task completed successfully!")
        print(f"[Task] Final reward: {reward}")

    except Exception as e:
        print(f"[Task] Exception occurred: {e}")
        raise
    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()