import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        descriptions, obs = task.reset()
        init_video_writers(obs)

        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        positions = get_object_positions()
        tomato2_pos = positions.get('tomato2')
        tomato1_pos = positions.get('tomato1')
        plate_pos   = positions.get('plate')
        # Alias for frozen plan variable
        item1_pos = tomato1_pos

        if tomato2_pos is None or tomato1_pos is None or plate_pos is None:
            raise KeyError("One or more required objects not found: tomato2, tomato1, plate")

        try:
            # Execute oracle plan
            obs, reward, done = pick(env, task, target_pos=tomato2_pos)
            obs, reward, done = place(env, task, target_pos=plate_pos)
            obs, reward, done = pick(env, task, target_pos=item1_pos)
            obs, reward, done = place(env, task, target_pos=plate_pos)

            if done:
                print("[Task] Task completed successfully! Reward:", reward)
            else:
                print("[Task] Plan finished (done=False). Current reward:", reward)
        except Exception as e:
            print("[Task] Exception during execution:", e)

    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()