[Frozen Code Start]
    
[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers (optional)
        init_video_writers(obs)

        # Wrap step and get_observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        plate_pos   = positions['plate']

        # === Oracle Plan Execution ===

        # Step 1: pick tomato1 from its initial location
        print("[Task] Picking tomato1 at position:", tomato1_pos)
        try:
            obs, reward, done = pick(
                env,
                task,
                target_pos=tomato1_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        except Exception as e:
            print(f"[Error] pick(tomato1): {e}")
            return
        if done:
            print("[Task] Ended after pick(tomato1). Reward:", reward)
            return

        # Step 2: place tomato1 onto the plate
        print("[Task] Placing tomato1 onto plate at position:", plate_pos)
        try:
            obs, reward, done = place(
                env,
                task,
                target_pos=plate_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        except Exception as e:
            print(f"[Error] place(tomato1): {e}")
            return
        if done:
            print("[Task] Ended after place(tomato1). Reward:", reward)
            return

        # Step 3: pick tomato2 from its initial location
        print("[Task] Picking tomato2 at position:", tomato2_pos)
        try:
            obs, reward, done = pick(
                env,
                task,
                target_pos=tomato2_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        except Exception as e:
            print(f"[Error] pick(tomato2): {e}")
            return
        if done:
            print("[Task] Ended after pick(tomato2). Reward:", reward)
            return

        # Step 4: place tomato2 onto the plate
        print("[Task] Placing tomato2 onto plate at position:", plate_pos)
        try:
            obs, reward, done = place(
                env,
                task,
                target_pos=plate_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        except Exception as e:
            print(f"[Error] place(tomato2): {e}")
            return
        if done:
            print("[Task] Ended after place(tomato2). Reward:", reward)
            return

        # Final Status
        print("[Task] Oracle plan executed. Final reward:", reward, "Done flag:", done)

    finally:
        # Always shut down the environment
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()
