import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video recording if needed
        init_video_writers(obs)
        # Wrap step and get_observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve object positions
        positions = get_object_positions()

        # Map spec objects to environment keys
        tomato1_key = 'item1'
        tomato2_key = 'tomato2'
        plate_key = 'plate'

        if tomato1_key not in positions or tomato2_key not in positions or plate_key not in positions:
            raise KeyError(f"Missing object in positions: {tomato1_key}, {tomato2_key}, or {plate_key}")

        # Convert positions to numpy arrays
        tomato1_pos = np.array(positions[tomato1_key])
        tomato2_pos = np.array(positions[tomato2_key])
        plate_pos = np.array(positions[plate_key])

        # Execute oracle plan
        # Step 1-4 are frozen below
        obs, reward, done = pick(env, task, target_pos=tomato1_pos)
        obs, reward, done = place(env, task, target_pos=plate_pos)
        obs, reward, done = pick(env, task, target_pos=tomato2_pos)
        obs, reward, done = place(env, task, target_pos=plate_pos)

        # Check outcome
        if done:
            print("[Task] Episode ended early. Reward:", reward)
        else:
            print("[Task] Completed all steps successfully. Final Reward:", reward)

    except Exception as e:
        print(f"[Task] Exception encountered: {e}")
    finally:
        shutdown_environment(env)
        print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()