        if done:
            print("[Task] Task ended prematurely during placing item1")
            return

        # Step 3: pick tomato2 from table
        print("[Task] Picking tomato2 from table at:", tomato2_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=tomato2_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended prematurely during picking tomato2")
            return

        # Step 4: place tomato2 onto plate
        print("[Task] Placing tomato2 onto plate at:", plate_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended prematurely during placing tomato2")
            return

        print("[Task] Completed transferring tomatoes onto plate! Final reward:", reward)

    except Exception as e:
        print(f"[Task] Exception encountered: {e}")
        raise

    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()