import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor
from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        descriptions, obs = task.reset()
        init_video_writers(obs)
        # wrap for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)
        # get object positions
        positions = get_object_positions()
        try:
            tomato1_pos = positions['tomato1']
            tomato2_pos = positions['tomato2']
            plate_pos   = positions['plate']
        except KeyError as e:
            print(f"[Error] Missing object in positions: {e}")
            return
        # Step 1: Pick tomato1 from table
        print("[Task] Picking tomato1 from table at:", tomato1_pos)
        obs, reward, done = pick(
                env,
                task,
                target_pos=tomato1_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        if done:
            print("[Task] Ended early during pick tomato1. Reward:", reward)
            return
        # Step 2: Place tomato1 on plate
        print("[Task] Placing tomato1 on plate at:", plate_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Ended early during place tomato1. Reward:", reward)
            return
        # Step 3: Pick tomato2 from table
        print("[Task] Picking tomato2 from table at:", tomato2_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=tomato2_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Ended early during pick tomato2. Reward:", reward)
            return
        # Step 4: Place tomato2 on plate
        print("[Task] Placing tomato2 on plate at:", plate_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Ended early during place tomato2. Reward:", reward)
            return
        # Completed plan
        print("[Task] Completed oracle plan: all tomatoes are on the plate. Final Reward:", reward)
    finally:
        shutdown_environment(env)
    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()