import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        plate_pos = positions['plate']

        # === Execute Oracle Plan ===

        print("[Task] Picking tomato1 at:", tomato1_pos)
        [Frozen Code Start]
        obs, reward, done = pick(env, task, target_pos=tomato1_pos)
        [Frozen Code End]
        if done:
            print("[Task] Terminated early after picking tomato1. Reward:", reward)
            return

        print("[Task] Placing tomato1 on plate at:", plate_pos)
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Terminated early after placing tomato1. Reward:", reward)
            return

        print("[Task] Picking tomato2 at:", tomato2_pos)
        obs, reward, done = pick(env, task, target_pos=tomato2_pos)
        if done:
            print("[Task] Terminated early after picking tomato2. Reward:", reward)
            return

        print("[Task] Placing tomato2 on plate at:", plate_pos)
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Terminated early after placing tomato2. Reward:", reward)
            return

        # Final check
        if not done:
            print("[Task] Completed all steps. Final reward:", reward)
        else:
            print("[Task] Done flag received at end. Reward:", reward)

    except Exception as e:
        print(f"[Task] Exception encountered: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()