def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a list of tomatoes and a plate
        tomato_positions = [positions['tomato1'], positions['tomato2'], positions['tomato3']]
        plate_position = positions['plate']

        # Step 1: Move to the first tomato
        print("[Task] Moving to tomato 1 at:", tomato_positions[0])
        obs, reward, done = move(env, task, obs.robot_position, tomato_positions[0])
        if done:
            print("[Task] Task ended after moving to tomato 1!")
            return

        # Step 2: Pick the first tomato
        print("[Task] Picking tomato 1")
        obs, reward, done = pick(env, 'tomato1', tomato_positions[0], 'gripper')
        if done:
            print("[Task] Task ended after picking tomato 1!")
            return

        # Step 3: Move to the plate
        print("[Task] Moving to the plate at:", plate_position)
        obs, reward, done = move(env, task, obs.robot_position, plate_position)
        if done:
            print("[Task] Task ended after moving to the plate!")
            return

        # Step 4: Place the first tomato on the plate
        print("[Task] Placing tomato 1 on the plate")
        obs, reward, done = place(env, 'tomato1', plate_position)
        if done:
            print("[Task] Task ended after placing tomato 1!")
            return

        # Repeat for the second and third tomatoes
        for i in range(1, 3):
            print(f"[Task] Moving to tomato {i + 1} at:", tomato_positions[i])
            obs, reward, done = move(env, task, obs.robot_position, tomato_positions[i])
            if done:
                print(f"[Task] Task ended after moving to tomato {i + 1}!")
                return

            print(f"[Task] Picking tomato {i + 1}")
            obs, reward, done = pick(env, f'tomato{i + 1}', tomato_positions[i], 'gripper')
            if done:
                print(f"[Task] Task ended after picking tomato {i + 1}!")
                return

            print(f"[Task] Moving to the plate at:", plate_position)
            obs, reward, done = move(env, task, obs.robot_position, plate_position)
            if done:
                print(f"[Task] Task ended after moving to the plate!")
                return

            print(f"[Task] Placing tomato {i + 1} on the plate")
            obs, reward, done = place(env, f'tomato{i + 1}', plate_position)
            if done:
                print(f"[Task] Task ended after placing tomato {i + 1}!")
                return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()