def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have objects named 'tomato1' and 'tomato2' in the environment
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        switch_pos = positions['switch']  # Assuming there's a switch to press

        # Step 1: Move to tomato1
        print("[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato1_pos)
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return

        # Step 2: Pick tomato1
        print("[Task] Picking up tomato1")
        obs, reward, done = pick(env, task, 'tomato1', obs.robot_position)
        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        # Step 3: Move to the switch
        print("[Task] Moving to switch at:", switch_pos)
        obs, reward, done = move(env, task, obs.robot_position, switch_pos)
        if done:
            print("[Task] Task ended after moving to switch!")
            return

        # Step 4: Press the switch
        print("[Task] Pressing the switch")
        obs, reward, done = press(env, task, switch_pos)
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

        # Step 5: Move to tomato2
        print("[Task] Moving to tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato2_pos)
        if done:
            print("[Task] Task ended after moving to tomato2!")
            return

        # Step 6: Pick tomato2
        print("[Task] Picking up tomato2")
        obs, reward, done = pick(env, task, 'tomato2', obs.robot_position)
        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        # Step 7: Move back to the initial position (if needed)
        print("[Task] Moving back to initial position")
        obs, reward, done = move(env, task, obs.robot_position, descriptions.initial_position)
        if done:
            print("[Task] Task ended after moving back to initial position!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()