def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a 'robot' and 'object' in the environment
        robot_position = positions['robot']
        object_position = positions['object']

        # Step 1: Move to the object's location
        print("[Task] Moving to the object's location:", object_position)
        obs, reward, done = move(env, task, robot_position, object_position)
        if done:
            print("[Task] Task ended after moving to the object!")
            return

        # Step 2: Pick up the object
        print("[Task] Picking up the object at:", object_position)
        obs, reward, done = pick(env, task, 'object', object_position)
        if done:
            print("[Task] Task ended after picking up the object!")
            return

        # Step 3: Move to a new location (e.g., disposal area)
        disposal_position = positions['disposal_area']
        print("[Task] Moving to the disposal area:", disposal_position)
        obs, reward, done = move(env, task, object_position, disposal_position)
        if done:
            print("[Task] Task ended after moving to the disposal area!")
            return

        # Step 4: Place the object in the disposal area
        print("[Task] Placing the object at:", disposal_position)
        obs, reward, done = place(env, task, 'object', disposal_position)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()