def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have objects 'tomato1' and 'rubbish' in the environment
        tomato1_pos = positions.get('tomato1')
        rubbish_pos = positions.get('rubbish')

        # Check if the objects are present
        if tomato1_pos is None or rubbish_pos is None:
            print("Error: Required objects are not present in the environment.")
            return

        # Step 1: Move to the location of tomato1
        print("[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato1_pos)
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return

        # Step 2: Pick up tomato1
        print("[Task] Picking up tomato1.")
        obs, reward, done = pick(env, 'tomato1', obs.robot_position)
        if done:
            print("[Task] Task ended after picking up tomato1!")
            return

        # Step 3: Move to the rubbish location
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, obs.robot_position, rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Step 4: Place tomato1 in the rubbish
        print("[Task] Placing tomato1 in rubbish.")
        obs, reward, done = place(env, 'tomato1', rubbish_pos)
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()