def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a target object named 'tomato'
        target_object_name = 'tomato'
        target_object_pos = positions.get(target_object_name)

        if target_object_pos is None:
            print(f"Target object '{target_object_name}' not found in object list.")
            return

        # Move to the target object's position
        print(f"[Task] Moving to {target_object_name} at:", target_object_pos)
        obs, reward, done = move(env, task, obs.robot_position, target_object_pos)

        if done:
            print("[Task] Task ended after moving to the target position!")
            return

        # Attempt to pick the target object
        print(f"[Task] Attempting to pick {target_object_name}.")
        obs, reward, done = pick(env, task, target_object_name, target_object_pos)

        if done:
            print("[Task] Task ended after picking the target object!")
            return

        # Move to a designated drop-off location (assuming we have a drop-off position)
        drop_off_pos = positions.get('drop_off_location')  # Replace with actual drop-off location
        if drop_off_pos is None:
            print("Drop-off location not found.")
            return

        print(f"[Task] Moving to drop-off location at:", drop_off_pos)
        obs, reward, done = move(env, task, obs.robot_position, drop_off_pos)

        if done:
            print("[Task] Task ended after moving to the drop-off location!")
            return

        # Attempt to place the object at the drop-off location
        print(f"[Task] Attempting to place {target_object_name} at drop-off location.")
        obs, reward, done = place(env, task, target_object_name, drop_off_pos)

        if done:
            print("[Task] Task ended after placing the target object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()