def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a ball object to pick
        ball_pos = positions['ball']  # Replace 'ball' with the actual object name
        room_pos = positions['room']  # Replace 'room' with the actual room name

        # Step 1: Move to the room where the ball is located
        print("[Task] Moving to the room...")
        obs, reward, done = move(env, task, from_room=room_pos, to_room=room_pos)
        if done:
            print("[Task] Task ended after moving to the room!")
            return

        # Step 2: Pick the ball
        print("[Task] Picking the ball at:", ball_pos)
        obs, reward, done = pick(env, task, target_pos=ball_pos, approach_distance=0.15, max_steps=100, threshold=0.05, approach_axis='z', timeout=15.0)
        if done:
            print("[Task] Task ended after picking the ball!")
            return

        # Step 3: Move to the drop location (assuming a drop location is defined)
        drop_location = positions['drop_location']  # Replace with actual drop location
        print("[Task] Moving to the drop location...")
        obs, reward, done = move(env, task, from_room=room_pos, to_room=drop_location)
        if done:
            print("[Task] Task ended after moving to the drop location!")
            return

        # Step 4: Place the ball down
        print("[Task] Placing the ball at:", drop_location)
        obs, reward, done = place(env, task, target_pos=drop_location)
        if done:
            print("[Task] Task ended after placing the ball!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()