import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Plan: put rubbish in bin
        rubbish_pos = positions.get('rubbish', None)
        if rubbish_pos is None:
            raise ValueError("Rubbish position not found in object positions.")
        bin_pos = positions.get('bin', None)
        if bin_pos is None:
            raise ValueError("Bin position not found in object positions.")

        # Step 1: Pick the rubbish
        print("[Task] Picking rubbish at:", rubbish_pos)
        obs, reward, done = pick(
                env,
                task,
                target_pos=np.array(rubbish_pos)
        )
        if done:
            print("[Task] Task ended during pick of rubbish! Reward:", reward)
            return

        # Step 2: Place the rubbish into the bin
        print("[Task] Placing rubbish in bin at:", bin_pos)
        obs, reward, done = place(
                env,
                task,
                target_pos=np.array(bin_pos)
        )
        if done:
            print("[Task] Task ended during place of rubbish! Reward:", reward)
            return

        print("[Task] Successfully placed rubbish in bin. Task completed! Reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()