import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Plan Step 1: Pick rubbish from table ===
        rubbish_pos = positions.get('rubbish')
        if rubbish_pos is None:
            raise RuntimeError("Position for 'rubbish' not found in environment.")
        # alias to satisfy frozen snippet variable name
        item1_pos = rubbish_pos
        print("[Task] Picking up rubbish from table at:", rubbish_pos)
        obs, reward, done = pick(
                env,
                task,
                target_pos=np.array(item1_pos)
        )
        if done:
            print("[Task] Task ended during pick! Reward:", reward)
            return

        # === Plan Step 2: Place rubbish into bin ===
        bin_pos = positions.get('bin')
        if bin_pos is None:
            raise RuntimeError("Position for 'bin' not found in environment.")
        print("[Task] Placing rubbish into bin at:", bin_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=np.array(bin_pos)
        )
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task not completed yet (done=False). Reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()