        if done:
            print("[Task] Task ended unexpectedly during pick. Reward:", reward)
            return

        # Step 2: Place the rubbish ('item1') into the trash can ('bin')
        bin_pos = positions.get('bin')
        if bin_pos is None:
            raise KeyError("Position for 'bin' not found in environment")
        print("[Task] Placing 'item1' into 'bin' at:", bin_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=bin_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended unexpectedly during place. Reward:", reward)
            return

        # === Task Completion ===
        print("[Task] Completed the plan. Final reward:", reward)
        return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()