from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions
import numpy as np

def run_skeleton_task():
    '''Run the oracle plan: pick rubbish from table and place it in bin.'''
    print("===== Starting Skeleton Task =====")
    
    env, task = setup_environment()
    try:
        descriptions, obs = task.reset()
        init_video_writers(obs)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)
        
        # Retrieve positions
        positions = get_object_positions()
        rubbish_pos = np.array(positions['rubbish'])
        bin_pos = np.array(positions['bin'])
        
        common_kwargs = dict(
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        
        [Frozen Code Start]
        obs, reward, done = pick(env, task, target_pos=item1_pos, **common_kwargs)
obs, reward, done = place(env, task, target_pos=bin_pos, **common_kwargs)
obs, reward, done = pick(env, task, target_pos=item2_pos, **common_kwargs)
obs, reward, done = place(env, task, target_pos=bin_pos, **common_kwargs)
        [Frozen Code End]
        
        # Step 1: pick rubbish
        print("[Task] Step 1: Picking rubbish at:", rubbish_pos)
        obs, reward, done = pick(env, task, target_pos=rubbish_pos, **common_kwargs)
        if done:
            print("[Task] Early termination after pick(rubbish). Reward:", reward)
            return
        
        # Step 2: place rubbish in bin
        print("[Task] Step 2: Placing rubbish to bin at:", bin_pos)
        obs, reward, done = place(env, task, target_pos=bin_pos, **common_kwargs)
        if done:
            print("[Task] Early termination after place(rubbish). Reward:", reward)
            return
        
        if done:
            print("[Task] Task ended exactly after last action. Reward:", reward)
        else:
            print("[Task] Task completed successfully! Final reward:", reward)
    
    except Exception as e:
        print("[Task] Error during execution:", str(e))
    
    finally:
        shutdown_environment(env)
        print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()