import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing simulation
        init_video_writers(obs)

        # Wrap the task.step and task.get_observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        try:
            rubbish_pos = np.array(positions['rubbish'])
            bin_pos     = np.array(positions['bin'])
        except KeyError as e:
            print(f"[Error] Missing object in positions: {e}")
            return

        # === Execute Oracle Plan Steps ===
        print(f"[Task] Step 1: Picking 'rubbish' at position {rubbish_pos}")
        print(f"[Task] Step 2: Placing 'rubbish' into 'bin' at position {bin_pos}")
        try:
            # Frozen Code Start
            obs, reward, done = pick(
                        env,
                        task,
                        target_pos=rubbish_pos,
                        approach_distance=0.15,
                        max_steps=100,
                        threshold=0.01,
                        approach_axis='z',
                        timeout=10.0
                    )
            obs, reward, done = place(
                        env,
                        task,
                        target_pos=bin_pos,
                        approach_distance=0.15,
                        max_steps=100,
                        threshold=0.01,
                        approach_axis='z',
                        timeout=10.0
                    )
            # Frozen Code End
        except Exception as e:
            print(f"[Error] Exception during plan execution: {e}")
            return

        if done:
            print(f"[Task] Task completed successfully! Final reward: {reward}")
        else:
            print(f"[Task] Task did not complete. Current reward: {reward}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()