from env import setup_environment, shutdown_environment
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions
from skill_code import pick, place

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        # Reset the task and initialize video recording
        descriptions, obs = task.reset()
        init_video_writers(obs)
        # Wrap step and get_observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve object positions
        positions = get_object_positions()
        rubbish_pos = positions.get('rubbish')
        bin_pos = positions.get('bin')
        if rubbish_pos is None or bin_pos is None:
            raise ValueError("Object positions for 'rubbish' or 'bin' not found.")

        # Step 1: Pick the rubbish
        print("[Task] Picking 'rubbish' at:", rubbish_pos)
        obs, reward, done = pick(
                env,
                task,
                target_pos=rubbish_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
        if done:
            print("[Task] Episode ended prematurely after pick. Reward:", reward)
            return

        # Step 2: Place the rubbish into the bin
        print("[Task] Placing 'rubbish' into 'bin' at:", bin_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=bin_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task not completed yet (done=False). Reward:", reward)

    except Exception as e:
        print(f"[Task] Exception occurred during execution: {e}")
    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()