[Frozen Code Start]

[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Run the task of picking up rubbish and placing it in the bin.'''
    print("===== Starting Skeleton Task =====")
    env, task = setup_environment()
    try:
        # Reset and initialize
        descriptions, obs = task.reset()
        init_video_writers(obs)

        # Wrap for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Get object positions
        positions = get_object_positions()
        if 'rubbish' not in positions:
            raise KeyError("Position for 'rubbish' not found in environment.")
        if 'bin' not in positions:
            raise KeyError("Position for 'bin' not found in environment.")
        rubbish_pos = np.array(positions['rubbish'])
        bin_pos = np.array(positions['bin'])

        # Step 1: pick rubbish
        print("[Task] Step 1: Picking up 'rubbish'.")
        obs, reward, done = pick(
            env,
            task,
            target_pos=rubbish_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended during pick. Reward:", reward)
            return

        # Step 2: place rubbish into bin
        print("[Task] Step 2: Placing 'rubbish' into 'bin'.")
        obs, reward, done = place(
            env,
            task,
            target_pos=bin_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task not completed yet. done:", done, "reward:", reward)

    except Exception as e:
        print("[Task] Exception during execution:", str(e))
    finally:
        shutdown_environment(env)
    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()
