from env import setup_environment, shutdown_environment
import numpy as np
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset task to initial state
        descriptions, obs = task.reset()
        # Initialize video recording if desired
        init_video_writers(obs)
        # Wrap step and get_observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # We expect keys 'rubbish' and 'bin'
        rubbish_pos = np.array(positions['rubbish'])
        bin_pos = np.array(positions['bin'])

        # === Oracle Plan Execution ===
        # Step 1: pick rubbish from table
        print("[Task] Step 1: Picking 'rubbish' at:", rubbish_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=rubbish_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after Step 1. Reward:", reward)
            return

        # Step 2: place rubbish into bin
        print("[Task] Step 2: Placing 'rubbish' at bin:", bin_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=bin_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after Step 2. Reward:", reward)
            return

        # All steps done
        print("[Task] Completed all plan steps. Final reward:", reward)

    except Exception as e:
        print(f"[Task] Exception during execution: {e}")
    finally:
        shutdown_environment(env)
    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()