import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Run the specific disposal task: pick up the rubbish and place it in the bin.'''
    print("===== Starting Skeleton Task =====")

    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers if desired
        init_video_writers(obs)

        # Wrap step and get_observation for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve object positions
        positions = get_object_positions()
        if 'rubbish' not in positions or 'bin' not in positions:
            raise KeyError("Required object positions not found in environment.")
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']

        # === Execute Plan Step 1: pick rubbish from its current location ===
        print("[Task] Picking up 'rubbish' at position:", rubbish_pos)
        [Frozen Code Start]
        obs, reward, done = pick(
                env,
                task,
                target_pos=np.array(rubbish_pos)
        [Frozen Code End]
                ,approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
        )
        if done:
            print("[Task] Task ended during pick. Reward:", reward)
            return

        # === Execute Plan Step 2: place rubbish into the bin ===
        print("[Task] Placing 'rubbish' into 'bin' at position:", bin_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=np.array(bin_pos),
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task did not signal completion. Current reward:", reward)

    except Exception as e:
        print(f"[Error] Exception during task execution: {e}")
    finally:
        # Ensure environment is always shut down
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()