import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing your simulation (optional)
        init_video_writers(obs)

        # Wrap the task steps for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        rubbish_pos = positions.get('rubbish')
        bin_pos = positions.get('bin')
        if rubbish_pos is None or bin_pos is None:
            print("[Task] Error: 'rubbish' or 'bin' position not found.")
            return

        # === Execute Oracle Plan ===
        # Step 1: Pick up the rubbish from the table
        print("[Task] Picking up 'rubbish' at:", rubbish_pos)
        try:
            obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        except Exception as e:
            print("[Task] Exception during pick:", e)
            return
        if done:
            print("[Task] Task ended after pick! Reward:", reward)
            return

        # Step 2: Place the rubbish into the bin
        print("[Task] Placing 'rubbish' into 'bin' at:", bin_pos)
        try:
            obs, reward, done = place(env, task, target_pos=bin_pos)
        except Exception as e:
            print("[Task] Exception during place:", e)
            return
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task did not finish (done=False). Reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()