import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        rubbish_pos = positions.get('rubbish')
        bin_pos     = positions.get('bin')
        if rubbish_pos is None or bin_pos is None:
            raise KeyError("Could not find 'rubbish' or 'bin' in object positions.")

        # === Task Plan Execution ===
        # Step 1: Pick up the rubbish on the table
        print(f"[Task] Picking up rubbish at: {rubbish_pos}")
        obs, reward, done = pick(
                env,
                task,
                target_pos=np.array(rubbish_pos)
        )
        if done:
            print(f"[Task] Task ended prematurely after pick! Reward: {reward}")
            return

        # Step 2: Place the rubbish into the bin
        print(f"[Task] Placing rubbish into bin at: {bin_pos}")
        obs, reward, done = place(
            env,
            task,
            target_pos=np.array(bin_pos)
        )
        if done:
            print(f"[Task] Task completed successfully! Reward: {reward}")
        else:
            print(f"[Task] Task not completed yet (done=False). Current reward: {reward}")

    except Exception as e:
        print(f"[Task] Exception during execution: {e}")
    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()