def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming 'rubbish' is the object we want to pick
        rubbish_pos = positions.get('rubbish')
        if rubbish_pos is None:
            print("Rubbish not found in the environment.")
            return

        # Move to the location of the rubbish
        print(f"[Task] Moving to rubbish at: {rubbish_pos}")
        obs, reward, done = move(env, task, obs.robot_position, rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Attempt to pick up the rubbish
        print(f"[Task] Attempting to pick rubbish at: {rubbish_pos}")
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        if done:
            print("[Task] Task ended after picking rubbish!")
            return

        # If the rubbish was picked successfully, we can place it somewhere
        # Assuming we have a drop-off location, e.g., 'drop_zone'
        drop_zone_pos = positions.get('drop_zone')
        if drop_zone_pos is None:
            print("Drop zone not found in the environment.")
            return

        # Move to the drop zone
        print(f"[Task] Moving to drop zone at: {drop_zone_pos}")
        obs, reward, done = move(env, task, obs.robot_position, drop_zone_pos)
        if done:
            print("[Task] Task ended after moving to drop zone!")
            return

        # Place the rubbish in the drop zone
        print(f"[Task] Attempting to place rubbish at: {drop_zone_pos}")
        obs, reward, done = place(env, task, target_pos=drop_zone_pos)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()