def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming 'rubbish' is the object we want to pick and dispose of
        rubbish_pos = positions.get('rubbish')
        bin_pos = positions.get('bin')

        if rubbish_pos is None or bin_pos is None:
            print("Rubbish or bin position not found in the environment.")
            return

        # Move to the rubbish location
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, obs.robot_position, rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Check if the rubbish is at the current location
        if 'rubbish' in task.get_objects():
            # Attempt to pick up the rubbish
            print("[Task] Picking up rubbish.")
            obs, reward, done = pick(env, task, 'rubbish', rubbish_pos)
            if done:
                print("[Task] Task ended after picking up rubbish!")
                return
        else:
            print("Rubbish not found in current location.")
            return

        # Move to the bin location
        print("[Task] Moving to bin at:", bin_pos)
        obs, reward, done = move(env, task, rubbish_pos, bin_pos)
        if done:
            print("[Task] Task ended after moving to bin!")
            return

        # Attempt to drop the rubbish into the bin
        print("[Task] Dropping rubbish into bin.")
        obs, reward, done = place(env, task, 'rubbish', bin_pos)
        if done:
            print("[Task] Task ended after dropping rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()