def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a switch and a rubbish bin in the environment
        switch_pos = positions.get('switch', None)
        rubbish_bin_pos = positions.get('rubbish_bin', None)
        object_to_pick = 'rubbish'

        # Check if the switch and rubbish bin are available
        if switch_pos is None or rubbish_bin_pos is None:
            print("Error: Required objects are not present in the environment.")
            return

        # Move to the rubbish bin
        print("[Task] Moving to the rubbish bin at:", rubbish_bin_pos)
        obs, reward, done = move(env, task, 'current_location', rubbish_bin_pos)
        if done:
            print("[Task] Task ended after moving to the rubbish bin!")
            return

        # Pick up the rubbish
        print("[Task] Picking up the rubbish.")
        obs, reward, done = pick(env, object_to_pick, rubbish_bin_pos)
        if done:
            print("[Task] Task ended after picking up the rubbish!")
            return

        # Move to the switch
        print("[Task] Moving to the switch at:", switch_pos)
        obs, reward, done = move(env, task, rubbish_bin_pos, switch_pos)
        if done:
            print("[Task] Task ended after moving to the switch!")
            return

        # Press the switch
        print("[Task] Pressing the switch.")
        obs, reward, done = press(env, task, switch_pos)
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

        # Place the rubbish back (if needed)
        print("[Task] Placing the rubbish back.")
        obs, reward, done = place(env, object_to_pick, rubbish_bin_pos)
        if done:
            print("[Task] Task ended after placing the rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()