# run_skeleton_task.py  
import numpy as np  
from pyrep.objects.shape import Shape  
from pyrep.objects.proximity_sensor import ProximitySensor  

from env import setup_environment, shutdown_environment  

from skill_code import *  

from video import init_video_writers, recording_step, recording_get_observation  

from object_positions import get_object_positions  


def run_skeleton_task():  
    '''Task: Open one drawer in the cabinet and put the rubbish in the bin.'''  
    print("===== Starting Skeleton Task =====")  
    
    # === Environment Setup ===  
    env, task = setup_environment()  
    try:  
        # Reset the task to its initial state  
        descriptions, obs = task.reset()  

        # Initialize video writers (optional)  
        init_video_writers(obs)  

        # Wrap step and get_observation for recording  
        task.step = recording_step(task.step)  
        task.get_observation = recording_get_observation(task.get_observation)  

        # === Retrieve Object Positions ===  
        positions = get_object_positions()  
        bottom_side = positions['bottom_side_pos']  
        bottom_anchor = positions['bottom_anchor_pos']  
        rubbish_pos = positions['rubbish']  
        bin_pos = positions['bin']  

        # === Define Task Parameters ===  
        # Quaternion for 90° rotation about Z-axis: [x, y, z, w]  
        target_quat = np.array([0.0, 0.0, np.sqrt(2)/2, np.sqrt(2)/2])  
        pull_distance = 0.1  

        # === Execute Oracle Plan ===  
        print("[Task] Moving to bottom side position:", bottom_side)  
        [Frozen Code Start]  
        obs, reward, done = move(env, task, target_pos=bottom_side)  
        obs, reward, done = rotate(env, task, target_quat=target_quat)  
        obs, reward, done = move(env, task, target_pos=bottom_anchor)  
        obs, reward, done = pull(env, task, pull_distance=pull_distance, pull_axis='x')  
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)  
        obs, reward, done = place(env, task, target_pos=bin_pos)  
        [Frozen Code End]  

        # === Final Status ===  
        if done:  
            print("[Task] Completed successfully! Reward:", reward)  
        else:  
            print("[Task] Task finished but done flag is False. Reward:", reward)  

    finally:  
        # Always ensure the environment is properly shutdown  
        shutdown_environment(env)  

    print("===== End of Skeleton Task =====")  


if __name__ == "__main__":  
    run_skeleton_task()  
