from env import setup_environment, shutdown_environment
from skill_code import rotate, move, pull, pick, place
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions
import numpy as np

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        descriptions, obs = task.reset()
        init_video_writers(obs)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Execute the Oracle Plan ===
        try:
            # Step 1: Rotate gripper to 90 degrees about Z-axis
            print("[Plan] Step 1: Rotating gripper to 90 degrees (about Z-axis)")
            target_quat = np.array([0.0, 0.0, np.sin(np.pi/4), np.cos(np.pi/4)])
            
            # Step 2: Move to bottom drawer side position
            print("[Plan] Step 2: Move to bottom drawer side position")
            side_bottom = positions['bottom_side_pos']
            
            [Frozen Code Start]
    obs, reward, done = rotate(env, task, target_quat)
obs, reward, done = move(env, task, np.array(side_bottom)
            [Frozen Code End]
            if done:
                print("[Plan] Task ended after rotate/move-to-side.")
                return

            # Step 3: Move to bottom drawer anchor position
            print("[Plan] Step 3: Move to bottom drawer anchor position")
            anchor_bottom = positions['bottom_anchor_pos']
            obs, reward, done = move(env, task, np.array(anchor_bottom))
            if done:
                print("[Plan] Task ended after move-to-anchor.")
                return

            # Step 4: Pull bottom drawer to open it
            print("[Plan] Step 4: Pull bottom drawer to open it")
            obs, reward, done = pull(env, task, pull_distance=0.2)
            if done:
                print("[Plan] Task ended after pull.")
                return

            # Step 5: Move to rubbish position
            print("[Plan] Step 5: Move to rubbish position")
            rubbish_pos = positions['item3']
            obs, reward, done = move(env, task, np.array(rubbish_pos))
            if done:
                print("[Plan] Task ended after move-to-rubbish.")
                return

            # Step 6: Pick up the rubbish
            print("[Plan] Step 6: Pick up the rubbish")
            obs, reward, done = pick(env, task, np.array(rubbish_pos))
            if done:
                print("[Plan] Task ended after pick.")
                return

            # Step 7: Move to bin position
            print("[Plan] Step 7: Move to bin position")
            bin_pos = positions['bin']
            obs, reward, done = move(env, task, np.array(bin_pos))
            if done:
                print("[Plan] Task ended after move-to-bin.")
                return

            # Step 8: Place the rubbish into the bin
            print("[Plan] Step 8: Place the rubbish into the bin")
            obs, reward, done = place(env, task, np.array(bin_pos))
            if done:
                print("[Plan] Completed: Rubbish placed in bin. Reward:", reward)
            else:
                print("[Plan] Plan executed but done=False. Current reward:", reward)

        except Exception as e:
            print(f"[Plan] Exception during plan execution: {e}")
            raise

    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()