        # Step 3: Move to bottom anchor position
        print("[Plan] Step 3: move to bottom anchor position")
        obs, reward, done = move(env, task, np.array(bottom_anchor))
        if done:
            print("[Plan] Terminated early after move to anchor.")
            return

        # Step 4: Pull drawer open
        print("[Plan] Step 4: pull to open bottom drawer")
        obs, reward, done = pull(env, task, pull_distance=0.1)
        if done:
            print("[Plan] Terminated early after pull.")
            return

        # Step 5: pick up rubbish
        print("[Plan] Step 5: pick up rubbish")
        obs, reward, done = pick(env, task, np.array(rubbish_pos))
        if done:
            print("[Plan] Terminated early after pick.")
            return

        # Step 6: place rubbish in bin
        print("[Plan] Step 6: place rubbish in bin")
        obs, reward, done = place(env, task, np.array(bin_pos))
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task not completed (done=False). Final reward:", reward)

    except Exception as e:
        print(f"[Error] Exception during task execution: {e}")
        raise
    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()