import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Define plan parameters ===
        side_pos_bottom = np.array(positions['bottom_side_pos'])
        ninety_shape = Shape('ninety_deg')
        target_quat = normalize_quaternion(np.array(ninety_shape.get_quaternion()))
        anchor_pos_bottom = np.array(positions['bottom_anchor_pos'])
        pull_distance = 0.1
        pull_axis = 'x'
        rubbish_pos = np.array(positions['rubbish'])

        # === Oracle Plan Execution ===
        # Step 1–5 are frozen below. Do not modify.
        [Frozen Code Start]
        obs, reward, done = move(env, task, target_pos=side_pos_bottom)
        obs, reward, done = rotate(env, task, target_quat=target_quat)
        obs, reward, done = move(env, task, target_pos=anchor_pos_bottom)
        obs, reward, done = pull(env, task, pull_distance=pull_distance, pull_axis=pull_axis)
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        [Frozen Code End]

        # Check for early termination after pick
        if done:
            print("[Task] Early termination after pick.")
            return

        # Step 6: Place the rubbish into the bin
        bin_pos = np.array(positions['bin'])
        print(f"[Task] Step 6: Placing rubbish into bin at {bin_pos}")
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Task completed: rubbish placed in bin.")
        else:
            print(f"[Task] Task finished steps but done flag is False. Reward: {reward}")

    except Exception as e:
        print(f"[Task] Exception encountered during execution: {e}")
        raise
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()