def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example object positions (replace with actual keys)
        object_1_pos = positions['object_1']
        object_2_pos = positions['object_2']
        drawer_pos = positions['drawer']

        # 1) Move to the drawer
        print("[Task] Moving to the drawer...")
        obs, reward, done = move(env, 'initial_room', drawer_pos)
        if done:
            print("[Task] Task ended while moving to the drawer!")
            return

        # 2) Open the drawer
        print("[Task] Opening the drawer...")
        obs, reward, done = pull(env, 'gripper', 'drawer')
        if not obs.is_open:
            print("Error: Drawer opening failed.")
            return

        # 3) Pick the object from the drawer
        print("[Task] Picking the object from the drawer...")
        obs, reward, done = pick(env, 'object_1', drawer_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # 4) Move to the target position
        print("[Task] Moving to the target position...")
        target_pos = positions['target_bin']
        obs, reward, done = move(env, drawer_pos, target_pos)
        if done:
            print("[Task] Task ended while moving to the target position!")
            return

        # 5) Place the object in the target position
        print("[Task] Placing the object in the target position...")
        obs, reward, done = place(env, task, target_pos)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()