import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")

    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task
        descriptions, obs = task.reset()

        # Initialize video recording
        init_video_writers(obs)

        # Wrap step and get_observation to record
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        side_pos = positions['bottom_side_pos']
        anchor_pos = positions['bottom_anchor_pos']
        item1_pos = positions['item1']
        item2_pos = positions['item2']
        plate_pos = positions['plate']

        # === Oracle Plan Execution ===

        # Step 1: rotate gripper to ninety_deg
        target_quat = np.array([0.0, 0.0, np.sin(np.pi/4), np.cos(np.pi/4)])
        print("[Plan] Step 1: rotate gripper to ninety_deg")
    # Frozen code start
        obs, reward, done = rotate(env, task, target_quat=target_quat)
obs, reward, done = move(env, task, target_pos=np.array(side_pos)
    # Frozen code end
        if done:
            print("[Plan] Task ended after rotate. Reward:", reward)
            return

        # Step 3: move to drawer anchor position
        print("[Plan] Step 3: move to anchor_pos")
        obs, reward, done = move(env, task, target_pos=np.array(anchor_pos))
        if done:
            print("[Plan] Task ended after move to anchor_pos. Reward:", reward)
            return

        # Step 4: pull the drawer open
        print("[Plan] Step 4: pull drawer open")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Plan] Task ended after pull. Reward:", reward)
            return

        # Step 5: pick up the first tomato
        print("[Plan] Step 5: pick tomato1")
        obs, reward, done = pick(env, task, target_pos=np.array(item1_pos))
        if done:
            print("[Plan] Task ended after pick(tomato1). Reward:", reward)
            return

        # Step 6: place the first tomato on the plate
        print("[Plan] Step 6: place tomato1 on plate")
        obs, reward, done = place(env, task, target_pos=np.array(plate_pos))
        if done:
            print("[Plan] Task ended after place(tomato1). Reward:", reward)
            return

        # Step 7: pick up the second tomato
        print("[Plan] Step 7: pick tomato2")
        obs, reward, done = pick(env, task, target_pos=np.array(item2_pos))
        if done:
            print("[Plan] Task ended after pick(tomato2). Reward:", reward)
            return

        # Step 8: place the second tomato on the plate
        print("[Plan] Step 8: place tomato2 on plate")
        obs, reward, done = place(env, task, target_pos=np.array(plate_pos))
        if done:
            print("[Plan] Task completed! Final Reward:", reward)
        else:
            print("[Plan] Finished all steps but done flag is False. Reward:", reward)

    finally:
        # Always shutdown the environment
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()