[Frozen Code Start]
    
[Frozen Code End]

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers if recording is desired
        init_video_writers(obs)

        # Wrap step and observation functions for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        side_bottom = positions['bottom_side_pos']
        anchor_bottom = positions['bottom_anchor_pos']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        plate_pos   = positions['plate']

        # === Oracle Plan Execution ===

        # Step 1: Rotate gripper to 90 degrees around x-axis
        from scipy.spatial.transform import Rotation as R
        target_quat = R.from_euler('x', 90, degrees=True).as_quat()
        print("[Task] Step 1: rotate gripper to 90° around x-axis")
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Early termination after rotate. Reward:", reward)
            return

        # Step 2: Move to drawer side position (bottom)
        print("[Task] Step 2: move to side-pos-bottom:", side_bottom)
        obs, reward, done = move(env, task, side_bottom)
        if done:
            print("[Task] Early termination after move to side-pos. Reward:", reward)
            return

        # Step 3: Move to drawer anchor position (bottom)
        print("[Task] Step 3: move to anchor-pos-bottom:", anchor_bottom)
        obs, reward, done = move(env, task, anchor_bottom)
        if done:
            print("[Task] Early termination after move to anchor-pos. Reward:", reward)
            return

        # Step 4: Pull to open the drawer
        print("[Task] Step 4: pull to open drawer")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Task] Early termination after pull. Reward:", reward)
            return

        # Step 5: Pick tomato1 from the table
        print("[Task] Step 5: pick tomato1 at:", tomato1_pos)
        obs, reward, done = pick(env, task, tomato1_pos)
        if done:
            print("[Task] Early termination after pick tomato1. Reward:", reward)
            return

        # Step 6: Place tomato1 on the plate
        print("[Task] Step 6: place tomato1 on plate at:", plate_pos)
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Task] Early termination after place tomato1. Reward:", reward)
            return

        # Step 7: Pick tomato2 from the table
        print("[Task] Step 7: pick tomato2 at:", tomato2_pos)
        obs, reward, done = pick(env, task, tomato2_pos)
        if done:
            print("[Task] Early termination after pick tomato2. Reward:", reward)
            return

        # Step 8: Place tomato2 on the plate
        print("[Task] Step 8: place tomato2 on plate at:", plate_pos)
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Task] Early termination after place tomato2. Reward:", reward)
            return

        # Task completed successfully
        print("[Task] Completed all steps. Final reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()