import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        bottom_side_pos   = positions['bottom_side_pos']
        bottom_anchor_pos = positions['bottom_anchor_pos']
        tomato1_pos       = positions['tomato1']
        tomato2_pos       = positions['tomato2']
        plate_pos         = positions['plate']
        zero_quat         = positions['zero_deg']
        ninety_quat       = positions['ninety_deg']

        # === Oracle Plan Execution ===
        print("[Task] Step 1: rotate to ninety_deg")
        obs, reward, done = rotate(env, task, target_quat=ninety_quat)
        if done:
            print("[Task] Terminated early at step 1.")
            return

        print("[Task] Step 2: move to bottom side position")
        obs, reward, done = move(env, task, target_pos=bottom_side_pos)
        if done:
            print("[Task] Terminated early at step 2.")
            return

        print("[Task] Step 3: pull drawer open")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Task] Terminated early at step 3.")
            return

        print("[Task] Step 4: move to bottom anchor position")
        obs, reward, done = move(env, task, target_pos=bottom_anchor_pos)
        if done:
            print("[Task] Terminated early at step 4.")
            return

        print("[Task] Step 5: pick tomato1")
        obs, reward, done = pick(env, task, target_pos=tomato1_pos)
        if done:
            print("[Task] Terminated early at step 5.")
            return

        print("[Task] Step 6: move to plate position")
        obs, reward, done = move(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Terminated early at step 6.")
            return

        print("[Task] Step 7: place tomato1 on plate")
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Terminated early at step 7.")
            return

        # [Frozen Code Start]
        obs, reward, done = rotate(env, task, target_quat=ninety_quat)
        obs, reward, done = move(env, task, target_pos=bottom_side_pos)
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        obs, reward, done = move(env, task, target_pos=bottom_anchor_pos)
        obs, reward, done = pick(env, task, target_pos=tomato1_pos)
        obs, reward, done = move(env, task, target_pos=plate_pos)
        obs, reward, done = place(env, task, target_pos=plate_pos)
        # [Frozen Code End]

        # Continue with tomato2
        print("[Task] Step 8: move to tomato2 position")
        obs, reward, done = move(env, task, target_pos=tomato2_pos)
        if done:
            print("[Task] Terminated early at step 8.")
            return

        print("[Task] Step 9: pick tomato2")
        obs, reward, done = pick(env, task, target_pos=tomato2_pos)
        if done:
            print("[Task] Terminated early at step 9.")
            return

        print("[Task] Step 10: move to plate position for tomato2")
        obs, reward, done = move(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Terminated early at step 10.")
            return

        print("[Task] Step 11: place tomato2 on plate")
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Completed successfully! Reward:", reward)
        else:
            print("[Task] Task not completed (done=False). Final reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()