import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Task Plan Execution ===
        try:
            # Step 1: Move to the bottom drawer anchor position
            bottom_anchor_pos = positions.get('bottom_anchor_pos') or positions.get('anchor-pos-bottom')
            if bottom_anchor_pos is None:
                raise KeyError("bottom_anchor_pos not found in positions")
            print("[Task] Moving to bottom anchor pos:", bottom_anchor_pos)
            obs, reward, done = move(env, task, target_pos=bottom_anchor_pos)
            if done:
                print("[Task] Task ended after move!")
                return

            # Step 2: Pull the drawer open
            print("[Task] Pulling drawer open")
   [Frozen Code Start]
            obs, reward, done = move(env, task, target_pos=bottom_anchor_pos)
            obs, reward, done = pull(env, task, pull_distance=0.05, pull_axis='x')
   [Frozen Code End]
            if done:
                print("[Task] Task ended after pull!")
                return

            # Step 3: Pick tomato1
            tomato1_pos = positions.get('tomato1') or positions.get('tomato_1') or positions.get('item1')
            if tomato1_pos is None:
                raise KeyError("tomato1 position not found")
            print("[Task] Picking tomato1 at:", tomato1_pos)
            obs, reward, done = pick(env, task, target_pos=tomato1_pos)
            if done:
                print("[Task] Task ended after picking tomato1!")
                return

            # Step 4: Place tomato1 on the plate
            plate_pos = positions.get('plate')
            if plate_pos is None:
                raise KeyError("plate position not found")
            print("[Task] Placing tomato1 on plate at:", plate_pos)
            obs, reward, done = place(env, task, target_pos=plate_pos)
            if done:
                print("[Task] Task ended after placing tomato1!")
                return

            # Step 5: Pick tomato2
            tomato2_pos = positions.get('tomato2') or positions.get('tomato_2') or positions.get('item2')
            if tomato2_pos is None:
                raise KeyError("tomato2 position not found")
            print("[Task] Picking tomato2 at:", tomato2_pos)
            obs, reward, done = pick(env, task, target_pos=tomato2_pos)
            if done:
                print("[Task] Task ended after picking tomato2!")
                return

            # Step 6: Place tomato2 on the plate
            print("[Task] Placing tomato2 on plate at:", plate_pos)
            obs, reward, done = place(env, task, target_pos=plate_pos)
            if done:
                print("[Task] Task ended after placing tomato2!")
                return

            print("[Task] Completed all steps. Final reward:", reward)

        except Exception as e:
            print(f"[Task] Exception during execution: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()