        if done:
            print("[Task] Episode ended prematurely after rotate.")
            return

        # 3) Move to the anchor position of the bottom drawer (handle area)
        print("[Task] Moving to bottom drawer anchor position at:", positions['bottom_anchor_pos'])
        obs, reward, done = move(
            env, task,
            target_pos=np.array(positions['bottom_anchor_pos']),
            max_steps=100, threshold=0.01, timeout=10.0
        )
        if done:
            print("[Task] Episode ended prematurely after move to drawer anchor.")
            return

        # 4) Pull the drawer open along its X-axis by a fixed distance
        pull_distance = 0.1
        print(f"[Task] Pulling drawer open by {pull_distance}m along +X axis.")
        obs, reward, done = pull(
            env, task,
            pull_distance=pull_distance, pull_axis='x',
            max_steps=100, threshold=0.01, timeout=10.0
        )
        if done:
            print("[Task] Episode ended prematurely after pull.")
            return

        # 5) Move up to a neutral waypoint above the table (if defined)
        if 'waypoint1' in positions:
            print("[Task] Moving to neutral waypoint above table at:", positions['waypoint1'])
            obs, reward, done = move(
                env, task,
                target_pos=np.array(positions['waypoint1']),
                max_steps=100, threshold=0.01, timeout=10.0
            )
            if done:
                print("[Task] Episode ended prematurely after move to neutral waypoint.")
                return

        # 6) Pick tomato1
        print("[Task] Picking tomato1 at:", positions['tomato1'])
        obs, reward, done = pick(
            env, task,
            target_pos=np.array(positions['tomato1']),
            approach_distance=0.15, max_steps=100,
            threshold=0.01, approach_axis='z', timeout=10.0
        )
        if done:
            print("[Task] Episode ended prematurely after picking tomato1.")
            return

        # 7) Place tomato1 on the plate
        print("[Task] Placing tomato1 on plate at:", positions['plate'])
        obs, reward, done = place(
            env, task,
            target_pos=np.array(positions['plate']),
            approach_distance=0.15, max_steps=100,
            threshold=0.01, approach_axis='z', timeout=10.0
        )
        if done:
            print("[Task] Episode ended prematurely after placing tomato1.")
            return

        # 8) Return to neutral waypoint (if defined)
        if 'waypoint1' in positions:
            print("[Task] Returning to neutral waypoint at:", positions['waypoint1'])
            obs, reward, done = move(
                env, task,
                target_pos=np.array(positions['waypoint1']),
                max_steps=100, threshold=0.01, timeout=10.0
            )
            if done:
                print("[Task] Episode ended prematurely after return move.")
                return

        # 9) Pick tomato2
        print("[Task] Picking tomato2 at:", positions['tomato2'])
        obs, reward, done = pick(
            env, task,
            target_pos=np.array(positions['tomato2']),
            approach_distance=0.15, max_steps=100,
            threshold=0.01, approach_axis='z', timeout=10.0
        )
        if done:
            print("[Task] Episode ended prematurely after picking tomato2.")
            return

        # 10) Place tomato2 on the plate
        print("[Task] Placing tomato2 on plate at:", positions['plate'])
        obs, reward, done = place(
            env, task,
            target_pos=np.array(positions['plate']),
            approach_distance=0.15, max_steps=100,
            threshold=0.01, approach_axis='z', timeout=10.0
        )
        if done:
            print("[Task] Episode ended prematurely after placing tomato2.")
            return

        # Final status report
        if done or reward is not None:
            print(f"[Task] Finished plan execution. Reward: {reward}, done: {done}")
        else:
            print("[Task] Plan executed; check environment for completion status.")

    except Exception as e:
        print("[Task] Exception during execution:", str(e))
    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()