[Frozen Code Start]
    
[Frozen Code End]

        # === Retrieve Object Positions for Tomatoes and Plate ===
        positions = get_object_positions()
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        plate_pos = positions['plate']

        # === Execute Oracle Plan ===
        # Step 1: pick tomato1 from table
        print(f"[Task] Picking tomato1 at: {tomato1_pos}")
        obs, reward, done = pick(
            env,
            task,
            target_pos=tomato1_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print(f"[Task] Task ended after picking tomato1. Reward: {reward}")
            return

        # Step 2: place tomato1 on plate
        print(f"[Task] Placing tomato1 on plate at: {plate_pos}")
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print(f"[Task] Task ended after placing tomato1. Reward: {reward}")
            return

        # Step 3: pick tomato2 from table
        print(f"[Task] Picking tomato2 at: {tomato2_pos}")
        obs, reward, done = pick(
            env,
            task,
            target_pos=tomato2_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print(f"[Task] Task ended after picking tomato2. Reward: {reward}")
            return

        # Step 4: place tomato2 on plate
        print(f"[Task] Placing tomato2 on plate at: {plate_pos}")
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print(f"[Task] Task completed successfully! Reward: {reward}")
        else:
            print(f"[Task] Plan execution finished. Final reward: {reward}, Done flag: {done}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
