import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # you don't need to redefine primitives like move, pick, place

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        # Expected keys: 'tomato1', 'tomato2', 'plate', 'rubbish', etc.

        # Get positions for our plan objects
        tomato1_pos = positions.get('tomato1')
        if tomato1_pos is None:
            raise KeyError("Position for 'tomato1' not found in positions dict.")
        tomato2_pos = positions.get('tomato2')
        if tomato2_pos is None:
            raise KeyError("Position for 'tomato2' not found in positions dict.")
        plate_pos = positions.get('plate')
        if plate_pos is None:
            raise KeyError("Position for 'plate' not found in positions dict.")

        # === Oracle Plan Execution ===

        # Step 1: Pick up tomato1 from the table
        print("[Task] Picking tomato1 at:", tomato1_pos)
        # Step 2: Place tomato1 onto the plate
        print("[Task] Placing tomato1 on plate at:", plate_pos)
        # Step 3: Pick up tomato2 from the table
        print("[Task] Picking tomato2 at:", tomato2_pos)
        # Step 4: Place tomato2 onto the plate
        print("[Task] Placing tomato2 on plate at:", plate_pos)

        # Execute the frozen sequence of skills
        # [Frozen Code Start]
        obs, reward, done = pick(
            env,
            task,
            target_pos=tomato1_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        obs, reward, done = pick(
            env,
            task,
            target_pos=tomato2_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        # [Frozen Code End]

        # Check final status
        if done:
            print("[Task] Plan ended with done=True. Final reward:", reward)
        else:
            print("[Task] Completed placing all tomatoes on the plate. Final reward:", reward)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()