# run_put_rubbish_in_bin_task.py

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor
from env import setup_environment, shutdown_environment
from skill_code import pick, place
from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_put_rubbish_in_bin_task():
    print("===== Starting PutRubbishInBin Task =====")
    env, task = setup_environment()
    try:
        descriptions, obs = task.reset()
        init_video_writers(obs)

        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)
        
        positions = get_object_positions()
        
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']

        print("[Task] Picking rubbish at:", rubbish_pos)
        obs, reward, done = pick(
            env, task,
            target_pos=rubbish_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after picking!")
            return

        print("[Task] Placing rubbish in bin at:", bin_pos)
        obs, reward, done = place(
            env, task,
            target_pos=bin_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task not completed yet (done=False).")

    finally:
        shutdown_environment(env)

    print("===== End of PutRubbishInBin Task =====")

if __name__ == "__main__":
    run_put_rubbish_in_bin_task()
