# object_positions.py

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

def get_object_positions():
    success_sensor = ProximitySensor('success')
    bin_pos = success_sensor.get_position() + np.array([0, 0, 0.3])

    # rubbish
    rubbish_obj = Shape('rubbish')
    rubbish_pos = rubbish_obj.get_position()

    # tomato1
    tomato1_obj = Shape('tomato1')
    tomato1_pos = tomato1_obj.get_position()

    # tomato2
    tomato2_obj = Shape('tomato2')
    tomato2_pos = tomato2_obj.get_position()

    return {
        'plate': bin_pos,
        'item2': rubbish_pos,
        'item1': tomato1_pos,
        'item3': tomato2_pos
    }
